

//////////////////////////////////////////////////////////////////
//Result Code 
#define BXL_SUCCESS				0

#define BXL_READBUFFER_EMPTY	1

#define BXL_OTHERPTR_OPENED		100
#define BXL_NOT_OPENED			101
#define BXL_CREATE_ERROR		102
#define BXL_STATUS_ERROR		103
#define BXL_WATING_OPEN			104
#define BXL_CONNECT_ERROR		105
#define BXL_BDADDR_ERROR		106
#define BXL_NOT_SUPPORT			107
#define BXL_BAD_ARGUMENT		108 
#define BXL_BUFFER_ERROR		109 

#define BXL_REGISTRY_ERROR		200
#define BXL_WRITE_ERROR			300
#define BXL_READ_ERROR			301

#define BXL_BITMAPLOAD_ERROR	400
#define BXL_BITMAPDATA_ERROR	401

#define BXL_BC_DATA_ERROR		500
#define BXL_BC_NOT_SUPPORT		501

//MSR State Return
#define BXLMSR_FAILEDMODE		601
#define BXLMSR_NOTREADY			602
#define BXLMSR_DATAEMPTY		603

//Printer Status flag
#define BXL_STS_NORMAL		0
#define BXL_STS_PAPEREMPTY	1
#define BXL_STS_COVEROPEN	2
#define BXL_STS_POWEROVER	4
#define BXL_STS_MSR_READY	8
#define BXL_STS_PRINTING	16
#define BXL_STS_ERROR		32
#define BXL_STS_NOT_OPEN	64
#define BXL_STS_ERROR_OCCUR 128

//#define BXL_MSR_READYCOMPLETE	105

//Power Status
#define BXL_PWR_HIGH	0
#define BXL_PWR_MIDDLE	1
#define BXL_PWR_LOW		2
#define BXL_PWR_SMALL	3
#define BXL_PWR_NOT		4


//////////////////////////////////////////////////////////////////
//Alignment Code
#define BXL_ALIGNMENT_LEFT		0
#define BXL_ALIGNMENT_CENTER	1
#define BXL_ALIGNMENT_RIGHT		2

//////////////////////////////////////////////////////////////////////////
//Text Attribute
// 8 7 6 5 4 3  2      1 
//             BOLD   FONT AorB
//Font Attribute ⺻  : not Bold, FontA, not Underline, not reverse
#define BXL_FT_DEFAULT			0
#define BXL_FT_FONTB				1
#define BXL_FT_FONTC				16 
#define BXL_FT_BOLD					2
#define BXL_FT_UNDERLINE		4		
#define BXL_FT_REVERSE			8
#define BXL_ExFT_CHINA_FONTA			0 
#define BXL_ExFT_CHINA_FONTB			32

//Text Size Attribute
#define BXL_TS_0WIDTH			0
#define BXL_TS_1WIDTH			16
#define BXL_TS_2WIDTH			32
#define BXL_TS_3WIDTH			48
#define BXL_TS_4WIDTH			64
#define BXL_TS_5WIDTH			80
#define BXL_TS_6WIDTH			96
#define BXL_TS_7WIDTH			112

#define BXL_TS_0HEIGHT			0	
#define BXL_TS_1HEIGHT			1
#define BXL_TS_2HEIGHT			2
#define BXL_TS_3HEIGHT			3
#define BXL_TS_4HEIGHT			4
#define BXL_TS_5HEIGHT			5
#define BXL_TS_6HEIGHT			6
#define BXL_TS_7HEIGHT			7

//////////////////////////////////////////////////////////////////
//Width Full
#define BXL_WIDTH_FULL	-1
#define BXL_WIDTH_NONE	-2

//////////////////////////////////////////////////////////////////
//Barcode
#define BXL_BCS_PDF417		200
#define BXL_BCS_QRCODE_MODEL2 202 
#define BXL_BCS_QRCODE_MODEL1 203 
#define BXL_BCS_DATAMATRIX	204 //2009 4 15 added
#define BXL_BCS_MAXICODE_MODE2	205 //2009 4 15 updated
#define BXL_BCS_MAXICODE_MODE3	206 //2009 4 15 updated
#define BXL_BCS_MAXICODE_MODE4	207 //2009 4 15 updated
	
#define BXL_BCS_UPCA		101
#define BXL_BCS_UPCE		102
#define BXL_BCS_EAN8		103
#define BXL_BCS_EAN13		104
#define BXL_BCS_JAN8		105
#define BXL_BCS_JAN13		106
#define BXL_BCS_ITF			107
#define BXL_BCS_Codabar		108
#define BXL_BCS_Code39		109
#define BXL_BCS_Code93		110
#define BXL_BCS_Code128		111

/////////////////////////////////////////////////////////////////
//Barcode text position
#define BXL_BC_TEXT_NONE		0
#define BXL_BC_TEXT_ABOVE		1
#define BXL_BC_TEXT_BELOW		2



/////////////////////////////////////////////////////////////////
//CharaterSet
#define BXL_CS_PC437		0
#define BXL_CS_PC850		2
#define BXL_CS_PC860		3
#define BXL_CS_PC863		4
#define BXL_CS_PC865		5
#define BXL_CS_WPC1252		16
#define BXL_CS_PC866		17
#define BXL_CS_PC852		18
#define BXL_CS_PC858		19
#define BXL_CS_PC864		22
#define BXL_CS_PC874		23
#define BXL_CS_WPC1253		24
#define BXL_CS_WPC1251		28
#define BXL_CS_PC737		29
#define BXL_CS_THAI16		31
#define BXL_CS_PC862		33
#define BXL_CS_PC855		36
#define BXL_CS_PC857		37
#define BXL_CS_USER			255

//International CharacterSet
#define BXL_ICS_USA			0
#define BXL_ICS_FRANCE		1
#define BXL_ICS_GERMANY		2
#define BXL_ICS_UK			3
#define BXL_ICS_DENMARK1	4
#define BXL_ICS_SWEDEN		5
#define BXL_ICS_ITALY		6
#define BXL_ICS_SPAIN		7
#define BXL_ICS_NORWAY		9
#define BXL_ICS_DENMARK2	10	



//MSR Mode 
#define BXL_MSRMODE_CMDTRACK12		0
#define BXL_MSRMODE_CMDTRACK23		1
#define BXL_MSRMODE_AUTOTRACK1		2
#define BXL_MSRMODE_AUTOTRACK2_1	3
#define BXL_MSRMODE_AUTOTRACK12		4
#define BXL_MSRMODE_AUTOTRACK2_2	5
#define BXL_MSRMODE_AUTOTRACK3		6
#define BXL_MSRMODE_AUTOTRACK23		7

//file ver 1.0.0.13 main ver 1.0.6 add Const, Message (for MSR)
#define WM_MSR_ARRIVED     (WM_USER+3)
#define BXL_LPARAM_MSR		 10 


#define BXL_MSG_TRACK1		0x01
#define BXL_MSG_TRACK2		0x02
#define BXL_MSG_TRACK3		0x04
#define BXL_MSG_TRACK_ENCRIPTION 0x08